<!DOCTYPE html>
<html lang="vi">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $page_title ?? 'Admin Panel' ?> - Telegram Shop</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.0/font/bootstrap-icons.css">
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { 
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif; 
            background: #f5f6fa;
            overflow-x: hidden;
        }
        
        /* Sidebar */
        .sidebar {
            position: fixed;
            top: 0;
            left: 0;
            height: 100vh;
            width: 260px;
            background: linear-gradient(180deg, #2c3e50 0%, #34495e 100%);
            overflow-y: auto;
            box-shadow: 2px 0 15px rgba(0,0,0,0.1);
            z-index: 1000;
        }
        .sidebar::-webkit-scrollbar { width: 5px; }
        .sidebar::-webkit-scrollbar-thumb { background: rgba(255,255,255,0.3); border-radius: 10px; }
        
        .sidebar-header {
            padding: 25px 20px;
            text-align: center;
            background: rgba(0,0,0,0.2);
            border-bottom: 1px solid rgba(255,255,255,0.1);
        }
        .sidebar-header h4 {
            color: white;
            margin: 0;
            font-size: 20px;
            font-weight: 600;
        }
        
        .sidebar-menu {
            padding: 15px 0;
        }
        .sidebar-menu .nav-link {
            color: #ecf0f1;
            padding: 14px 25px;
            margin: 5px 15px;
            border-radius: 10px;
            transition: all 0.3s ease;
            display: flex;
            align-items: center;
            font-size: 15px;
            text-decoration: none;
        }
        .sidebar-menu .nav-link i {
            margin-right: 12px;
            font-size: 18px;
            width: 22px;
            text-align: center;
        }
        .sidebar-menu .nav-link:hover {
            background: rgba(52, 152, 219, 0.4);
            color: white;
            transform: translateX(5px);
        }
        .sidebar-menu .nav-link.active {
            background: #3498db;
            color: white;
            box-shadow: 0 4px 15px rgba(52, 152, 219, 0.4);
        }
        
        /* Main Content */
        .main-content {
            margin-left: 260px;
            padding: 30px;
            min-height: 100vh;
        }
        
        /* Page Header */
        .page-header {
            margin-bottom: 30px;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .page-header h2 {
            color: #2c3e50;
            font-size: 28px;
            font-weight: 600;
            margin: 0;
        }
        
        /* Card */
        .card {
            border: none;
            border-radius: 12px;
            box-shadow: 0 2px 12px rgba(0,0,0,0.08);
            margin-bottom: 25px;
            transition: transform 0.3s ease;
        }
        .card:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 20px rgba(0,0,0,0.12);
        }
        .card-header {
            background: white;
            border-bottom: 2px solid #f0f0f0;
            padding: 18px 25px;
            font-weight: 600;
            font-size: 16px;
            border-radius: 12px 12px 0 0 !important;
        }
        
        /* Table */
        .table {
            margin-bottom: 0;
        }
        .table thead th {
            background: #f8f9fa;
            border-bottom: 2px solid #dee2e6;
            font-weight: 600;
            font-size: 14px;
            color: #495057;
            padding: 15px;
            white-space: nowrap;
        }
        .table tbody td {
            padding: 15px;
            vertical-align: middle;
            font-size: 14px;
        }
        .table tbody tr {
            transition: background 0.2s ease;
        }
        .table tbody tr:hover {
            background: #f8f9fa;
        }
        
        /* Badges */
        .badge {
            padding: 6px 12px;
            font-weight: 500;
            font-size: 12px;
            border-radius: 6px;
        }
        
        /* Buttons */
        .btn {
            padding: 10px 20px;
            border-radius: 8px;
            font-weight: 500;
            transition: all 0.3s ease;
        }
        .btn:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 12px rgba(0,0,0,0.15);
        }
        .btn-sm {
            padding: 6px 12px;
            font-size: 13px;
        }
        
        /* Stats Cards */
        .stats-card {
            border-radius: 15px;
            padding: 25px;
            color: white;
            height: 140px;
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            transition: all 0.3s ease;
            cursor: pointer;
        }
        .stats-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 10px 25px rgba(0,0,0,0.2);
        }
        .stats-card-icon {
            font-size: 40px;
            opacity: 0.9;
        }
        .stats-card-value {
            font-size: 32px;
            font-weight: bold;
            margin: 10px 0 5px 0;
        }
        .stats-card-label {
            font-size: 14px;
            opacity: 0.9;
        }
        
        /* Modal */
        .modal-content {
            border-radius: 12px;
            border: none;
        }
        .modal-header {
            background: #f8f9fa;
            border-radius: 12px 12px 0 0;
        }
        
        /* Form */
        .form-control, .form-select {
            border-radius: 8px;
            border: 1px solid #dee2e6;
            padding: 10px 15px;
        }
        .form-control:focus, .form-select:focus {
            border-color: #3498db;
            box-shadow: 0 0 0 0.2rem rgba(52, 152, 219, 0.25);
        }
    </style>
</head>
<body>
    <!-- Sidebar -->
    <div class="sidebar">
        <div class="sidebar-header">
            <h4><i class="bi bi-shop"></i> Admin Panel</h4>
        </div>
        <nav class="sidebar-menu">
            <a class="nav-link <?= ($current_page == 'index') ? 'active' : '' ?>" href="index.php">
                <i class="bi bi-speedometer2"></i> Dashboard
            </a>
            <a class="nav-link <?= ($current_page == 'products') ? 'active' : '' ?>" href="products.php">
                <i class="bi bi-box-seam"></i> Sản phẩm
            </a>
            <!-- <a class="nav-link <?= ($current_page == 'accounts') ? 'active' : '' ?>" href="accounts.php">
                <i class="bi bi-key"></i> Kho tài khoản
            </a> -->
            <a class="nav-link <?= ($current_page == 'orders') ? 'active' : '' ?>" href="orders.php">
                <i class="bi bi-cart-check"></i> Đơn hàng
            </a>
            <a class="nav-link <?= ($current_page == 'users') ? 'active' : '' ?>" href="users.php">
                <i class="bi bi-people"></i> Khách hàng
            </a>
            <a class="nav-link <?= ($current_page == 'logs') ? 'active' : '' ?>" href="logs.php">
                <i class="bi bi-file-text"></i> Nhật ký hoạt động
            </a>
            <a class="nav-link <?= ($current_page == 'settings') ? 'active' : '' ?>" href="settings.php">
                <i class="bi bi-gear"></i> Cài đặt
            </a>
        </nav>
    </div>

    <!-- Main Content -->
    <div class="main-content">
