<?php
require_once('../includes/config.php');
$current_page = 'products';
$page_title = 'Quản lý sản phẩm';

if(isset($_SESSION['message'])) {
    $message = $_SESSION['message'];
    unset($_SESSION['message']);
}

$products = $conn->query("SELECT p.*, COUNT(pa.id) as stock 
                         FROM products p 
                         LEFT JOIN product_accounts pa ON p.id = pa.product_id AND pa.is_sold = 0
                         GROUP BY p.id
                         ORDER BY p.id DESC");

include('../includes/header.php');
?>

<style>
    .product-name-link {
        color: #2c3e50;
        text-decoration: none;
        font-weight: 500;
        transition: all 0.3s ease;
        cursor: pointer;
    }
    .product-name-link:hover {
        color: #667eea;
        text-decoration: underline;
    }
</style>

<div class="page-header">
    <h2><i class="bi bi-box-seam"></i> Quản lý sản phẩm</h2>
    <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addProductModal">
        <i class="bi bi-plus-circle"></i> Thêm sản phẩm
    </button>
</div>

<?php if(isset($message)) echo $message; ?>

<div class="card">
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Tên sản phẩm</th>
                        <th>Mô tả</th>
                        <th>Giá</th>
                        <th>Danh mục</th>
                        <th>Tồn kho</th>
                        <th width="250">Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if($products && $products->num_rows > 0) {
                        while($product = $products->fetch_assoc()): 
                    ?>
                    <tr>
                        <td><strong>#<?= $product['id'] ?></strong></td>
                        <td>
                            <a href="#" 
                               class="product-name-link"
                               data-bs-toggle="modal" 
                               data-bs-target="#viewAccountsModal"
                               data-product-id="<?= $product['id'] ?>"
                               data-product-name="<?= htmlspecialchars($product['name']) ?>">
                                <i class="bi bi-eye"></i> <?= htmlspecialchars($product['name']) ?>
                            </a>
                        </td>
                        <td><?= htmlspecialchars($product['description']) ?></td>
                        <td><strong><?= number_format($product['price']) ?>đ</strong></td>
                        <td><span class="badge bg-info"><?= htmlspecialchars($product['category']) ?></span></td>
                        <td><span class="badge bg-<?= $product['stock'] > 0 ? 'success' : 'danger' ?>"><?= $product['stock'] ?></span></td>
                        <td>
                            <div class="btn-group" role="group">
                                <!-- Nút xem tài khoản -->
                                <button class="btn btn-sm btn-info" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#viewAccountsModal"
                                        data-product-id="<?= $product['id'] ?>"
                                        data-product-name="<?= htmlspecialchars($product['name']) ?>"
                                        title="Xem tài khoản">
                                    <i class="bi bi-eye"></i>
                                </button>
                                
                                <!-- Nút thêm tài khoản -->
                                <button class="btn btn-sm btn-success" 
                                        data-bs-toggle="modal" 
                                        data-bs-target="#addAccountModal"
                                        data-product-id="<?= $product['id'] ?>"
                                        data-product-name="<?= htmlspecialchars($product['name']) ?>"
                                        title="Thêm tài khoản">
                                    <i class="bi bi-plus-circle"></i>
                                </button>
                                
                                <!-- Nút sửa -->
                                <a href="edit_product.php?id=<?= $product['id'] ?>" 
                                   class="btn btn-sm btn-warning" 
                                   title="Sửa">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                
                                <!-- Nút xóa -->
                                <a href="delete_product.php?id=<?= $product['id'] ?>" 
                                   class="btn btn-sm btn-danger" 
                                   title="Xóa"
                                   onclick="return confirm('Bạn có chắc muốn xóa sản phẩm \'<?= htmlspecialchars($product['name']) ?>\'?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </div>
                        </td>
                    </tr>
                    <?php 
                        endwhile;
                    } else {
                        echo "<tr><td colspan='7' class='text-center text-muted py-4'>
                                <i class='bi bi-inbox fs-1 d-block mb-2'></i>
                                Chưa có sản phẩm nào
                              </td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Modal Xem Tài Khoản -->
<div class="modal fade" id="viewAccountsModal" tabindex="-1">
    <div class="modal-dialog modal-xl">
        <div class="modal-content">
            <div class="modal-header bg-info text-white">
                <h5 class="modal-title">
                    <i class="bi bi-list-ul"></i> 
                    Danh sách tài khoản: <span id="viewProductName"></span>
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <div id="accountsLoading" class="text-center py-4">
                    <div class="spinner-border text-primary" role="status">
                        <span class="visually-hidden">Loading...</span>
                    </div>
                </div>
                <div id="accountsList" style="display: none;"></div>
            </div>
        </div>
    </div>
</div>

<!-- Modal Thêm Sản Phẩm -->
<div class="modal fade" id="addProductModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title"><i class="bi bi-plus-circle"></i> Thêm sản phẩm mới</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="add_product.php">
                <div class="modal-body">
                    <div class="mb-3">
                        <label class="form-label">Tên sản phẩm *</label>
                        <input type="text" class="form-control" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Mô tả</label>
                        <textarea class="form-control" name="description" rows="3"></textarea>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Giá (VNĐ) *</label>
                        <input type="number" class="form-control" name="price" required>
                    </div>
                    <div class="mb-3">
                        <label class="form-label">Danh mục *</label>
                        <select class="form-select" name="category" required>
                            <option value="">-- Chọn danh mục --</option>
                            <option value="AI">AI</option>
                            <option value="Streaming">Streaming</option>
                            <option value="Music">Music</option>
                            <option value="Gaming">Gaming</option>
                            <option value="Other">Khác</option>
                        </select>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Hủy</button>
                    <button type="submit" class="btn btn-primary">
                        <i class="bi bi-check-circle"></i> Thêm sản phẩm
                    </button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Modal Thêm Tài Khoản -->
<div class="modal fade" id="addAccountModal" tabindex="-1">
    <div class="modal-dialog modal-lg">
        <div class="modal-content">
            <div class="modal-header bg-success text-white">
                <h5 class="modal-title">
                    <i class="bi bi-key"></i> 
                    Thêm tài khoản cho: <span id="productName"></span>
                </h5>
                <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
            </div>
            <div class="modal-body">
                <ul class="nav nav-tabs mb-3" role="tablist">
                    <li class="nav-item">
                        <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#singleAccount">
                            <i class="bi bi-plus-circle"></i> Thêm 1 tài khoản
                        </button>
                    </li>
                    <li class="nav-item">
                        <button class="nav-link" data-bs-toggle="tab" data-bs-target="#bulkAccounts">
                            <i class="bi bi-file-earmark-arrow-up"></i> Upload file TXT
                        </button>
                    </li>
                </ul>

                <div class="tab-content">
                    <div class="tab-pane fade show active" id="singleAccount">
                        <form method="POST" action="add_account.php">
                            <input type="hidden" name="product_id" id="singleProductId">
                            <div class="mb-3">
                                <label class="form-label">Thông tin tài khoản *</label>
                                <input type="text" class="form-control" name="account_data" 
                                       placeholder="email@example.com|password123" required>
                                <small class="text-muted">Format: email|password</small>
                            </div>
                            <button type="submit" class="btn btn-success w-100">
                                <i class="bi bi-check-circle"></i> Thêm tài khoản
                            </button>
                        </form>
                    </div>

                    <div class="tab-pane fade" id="bulkAccounts">
                        <form method="POST" action="bulk_add_accounts.php" enctype="multipart/form-data">
                            <input type="hidden" name="product_id" id="bulkProductId">
                            <div class="alert alert-info">
                                <i class="bi bi-info-circle"></i> <strong>Hướng dẫn:</strong>
                                <ul class="mb-0 mt-2">
                                    <li>Mỗi dòng là 1 tài khoản</li>
                                    <li>Format: <code>email|password</code></li>
                                </ul>
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Chọn file TXT</label>
                                <input type="file" class="form-control" name="accounts_file" accept=".txt">
                            </div>
                            <div class="mb-3">
                                <label class="form-label">Hoặc paste nội dung:</label>
                                <textarea class="form-control" name="accounts_text" rows="8" 
                                          placeholder="email1@example.com|password1&#10;email2@example.com|password2"></textarea>
                            </div>
                            <button type="submit" class="btn btn-success w-100">
                                <i class="bi bi-upload"></i> Upload & Thêm tài khoản
                            </button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
// Modal Thêm tài khoản
document.getElementById('addAccountModal').addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;
    const productId = button.getAttribute('data-product-id');
    const productName = button.getAttribute('data-product-name');
    
    document.getElementById('productName').textContent = productName;
    document.getElementById('singleProductId').value = productId;
    document.getElementById('bulkProductId').value = productId;
});

// Modal Xem tài khoản
document.getElementById('viewAccountsModal').addEventListener('show.bs.modal', function (event) {
    const button = event.relatedTarget;
    const productId = button.getAttribute('data-product-id');
    const productName = button.getAttribute('data-product-name');
    
    document.getElementById('viewProductName').textContent = productName;
    document.getElementById('accountsLoading').style.display = 'block';
    document.getElementById('accountsList').style.display = 'none';
    
    // Load accounts via AJAX
    fetch('get_accounts.php?product_id=' + productId)
        .then(response => response.text())
        .then(html => {
            document.getElementById('accountsLoading').style.display = 'none';
            document.getElementById('accountsList').innerHTML = html;
            document.getElementById('accountsList').style.display = 'block';
        })
        .catch(error => {
            document.getElementById('accountsLoading').style.display = 'none';
            document.getElementById('accountsList').innerHTML = '<div class="alert alert-danger">Lỗi tải dữ liệu!</div>';
            document.getElementById('accountsList').style.display = 'block';
        });
});
</script>

<?php include('../includes/footer.php'); ?>
