<?php
require_once('../includes/config.php');
$current_page = 'orders';
$page_title = 'Quản lý đơn hàng';

$orders = $conn->query("SELECT o.*, p.name, u.first_name, u.username, pa.account_data 
                       FROM orders o 
                       JOIN products p ON o.product_id = p.id 
                       JOIN users u ON o.user_id = u.telegram_id
                       JOIN product_accounts pa ON o.account_id = pa.id
                       ORDER BY o.created_at DESC");

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-cart-check"></i> Quản lý đơn hàng</h2>
</div>

<div class="card">
    <div class="card-header">
        <i class="bi bi-list-ul"></i> Danh sách đơn hàng
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Khách hàng</th>
                        <th>Telegram ID</th>
                        <th>Sản phẩm</th>
                        <th>Tài khoản</th>
                        <th>Giá</th>
                        <th>Trạng thái</th>
                        <th>Ngày mua</th>
                    </tr>
                </thead>
                <tbody>
                    <?php 
                    if($orders && $orders->num_rows > 0) {
                        while($order = $orders->fetch_assoc()): 
                    ?>
                    <tr>
                        <td><strong>#<?= $order['id'] ?></strong></td>
                        <td>
                            <?= htmlspecialchars($order['first_name']) ?>
                            <?php if($order['username']): ?>
                                <br><small class="text-muted">@<?= htmlspecialchars($order['username']) ?></small>
                            <?php endif; ?>
                        </td>
                        <td><code><?= $order['user_id'] ?></code></td>
                        <td><?= htmlspecialchars($order['name']) ?></td>
                        <td><code><?= htmlspecialchars($order['account_data']) ?></code></td>
                        <td><strong><?= number_format($order['total_price']) ?>đ</strong></td>
                        <td><span class="badge bg-success"><?= $order['status'] ?></span></td>
                        <td><?= date('d/m/Y H:i', strtotime($order['created_at'])) ?></td>
                    </tr>
                    <?php 
                        endwhile;
                    } else {
                        echo "<tr><td colspan='8' class='text-center text-muted py-4'>Chưa có đơn hàng nào</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Thống kê đơn hàng -->
<div class="row mt-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-bar-chart"></i> Thống kê theo sản phẩm
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Sản phẩm</th>
                                <th>Số lượng bán</th>
                                <th>Doanh thu</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $stats = $conn->query("SELECT p.name, COUNT(o.id) as total_orders, SUM(o.total_price) as revenue
                                                  FROM orders o
                                                  JOIN products p ON o.product_id = p.id
                                                  GROUP BY o.product_id
                                                  ORDER BY total_orders DESC");
                            if($stats && $stats->num_rows > 0) {
                                while($stat = $stats->fetch_assoc()) {
                            ?>
                            <tr>
                                <td><?= htmlspecialchars($stat['name']) ?></td>
                                <td><span class="badge bg-primary"><?= $stat['total_orders'] ?></span></td>
                                <td><strong><?= number_format($stat['revenue']) ?>đ</strong></td>
                            </tr>
                            <?php 
                                }
                            } else {
                                echo "<tr><td colspan='3' class='text-center text-muted py-4'>Chưa có dữ liệu</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
    
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <i class="bi bi-people-fill"></i> Top khách hàng
            </div>
            <div class="card-body p-0">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>Khách hàng</th>
                                <th>Số đơn</th>
                                <th>Tổng chi tiêu</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $top_customers = $conn->query("SELECT u.first_name, u.username, COUNT(o.id) as total_orders, SUM(o.total_price) as total_spent
                                                          FROM orders o
                                                          JOIN users u ON o.user_id = u.telegram_id
                                                          GROUP BY o.user_id
                                                          ORDER BY total_spent DESC
                                                          LIMIT 10");
                            if($top_customers && $top_customers->num_rows > 0) {
                                while($customer = $top_customers->fetch_assoc()) {
                            ?>
                            <tr>
                                <td>
                                    <?= htmlspecialchars($customer['first_name']) ?>
                                    <?php if($customer['username']): ?>
                                        <br><small class="text-muted">@<?= htmlspecialchars($customer['username']) ?></small>
                                    <?php endif; ?>
                                </td>
                                <td><span class="badge bg-info"><?= $customer['total_orders'] ?></span></td>
                                <td><strong><?= number_format($customer['total_spent']) ?>đ</strong></td>
                            </tr>
                            <?php 
                                }
                            } else {
                                echo "<tr><td colspan='3' class='text-center text-muted py-4'>Chưa có dữ liệu</td></tr>";
                            }
                            ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
