<?php
require_once('../includes/config.php');
$current_page = 'index';
$page_title = 'Dashboard';

// Lấy thống kê
$products_count = $conn->query("SELECT COUNT(*) as count FROM products")->fetch_assoc()['count'];
$accounts_count = $conn->query("SELECT COUNT(*) as count FROM product_accounts WHERE is_sold = 0")->fetch_assoc()['count'];
$orders_count = $conn->query("SELECT COUNT(*) as count FROM orders")->fetch_assoc()['count'];
$revenue = $conn->query("SELECT SUM(total_price) as total FROM orders WHERE status = 'completed'")->fetch_assoc()['total'] ?? 0;

include('../includes/header.php');
?>

<div class="page-header">
    <h2><i class="bi bi-speedometer2"></i> Dashboard</h2>
</div>

<!-- Stats Cards đơn giản -->
<div class="row g-4 mb-4">
    <div class="col-xl-3 col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-box-seam text-primary" style="font-size: 2.5rem;"></i>
                <h3 class="mt-2 mb-0"><?= $products_count ?></h3>
                <p class="text-muted mb-0">Sản phẩm</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-key text-success" style="font-size: 2.5rem;"></i>
                <h3 class="mt-2 mb-0"><?= $accounts_count ?></h3>
                <p class="text-muted mb-0">Tài khoản còn</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-cart-check text-warning" style="font-size: 2.5rem;"></i>
                <h3 class="mt-2 mb-0"><?= $orders_count ?></h3>
                <p class="text-muted mb-0">Đơn hàng</p>
            </div>
        </div>
    </div>
    <div class="col-xl-3 col-md-6">
        <div class="card">
            <div class="card-body text-center">
                <i class="bi bi-cash text-danger" style="font-size: 2.5rem;"></i>
                <h3 class="mt-2 mb-0"><?= number_format($revenue) ?>đ</h3>
                <p class="text-muted mb-0">Doanh thu</p>
            </div>
        </div>
    </div>
</div>

<!-- Đơn hàng gần đây -->
<div class="card">
    <div class="card-header">
        <i class="bi bi-clock-history"></i> Đơn hàng gần đây
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>User ID</th>
                        <th>Sản phẩm</th>
                        <th>Giá</th>
                        <th>Trạng thái</th>
                        <th>Thời gian</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $orders = $conn->query("SELECT o.*, p.name FROM orders o 
                                           JOIN products p ON o.product_id = p.id 
                                           ORDER BY o.created_at DESC LIMIT 10");
                    if($orders && $orders->num_rows > 0) {
                        while($order = $orders->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><strong>#<?= $order['id'] ?></strong></td>
                        <td><?= $order['user_id'] ?></td>
                        <td><?= htmlspecialchars($order['name']) ?></td>
                        <td><strong><?= number_format($order['total_price']) ?>đ</strong></td>
                        <td><span class="badge bg-success">completed</span></td>
                        <td><?= date('d/m/Y H:i', strtotime($order['created_at'])) ?></td>
                    </tr>
                    <?php 
                        }
                    } else {
                        echo "<tr><td colspan='6' class='text-center text-muted py-4'>Chưa có đơn hàng</td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<!-- Sản phẩm sắp hết -->
<div class="card">
    <div class="card-header">
        <i class="bi bi-exclamation-triangle text-warning"></i> Sản phẩm sắp hết
    </div>
    <div class="card-body p-0">
        <div class="table-responsive">
            <table class="table">
                <thead>
                    <tr>
                        <th>Sản phẩm</th>
                        <th>Giá</th>
                        <th>Tồn kho</th>
                        <th>Thao tác</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $low_stock = $conn->query("SELECT p.*, COUNT(pa.id) as stock 
                                              FROM products p 
                                              LEFT JOIN product_accounts pa ON p.id = pa.product_id AND pa.is_sold = 0
                                              GROUP BY p.id
                                              HAVING stock < 5
                                              ORDER BY stock ASC");
                    if($low_stock && $low_stock->num_rows > 0) {
                        while($product = $low_stock->fetch_assoc()) {
                    ?>
                    <tr>
                        <td><?= htmlspecialchars($product['name']) ?></td>
                        <td><?= number_format($product['price']) ?>đ</td>
                        <td><span class="badge bg-warning text-dark"><?= $product['stock'] ?></span></td>
                        <td>
                            <a href="products.php" class="btn btn-primary btn-sm">
                                <i class="bi bi-plus-circle"></i> Thêm tài khoản
                            </a>
                        </td>
                    </tr>
                    <?php 
                        }
                    } else {
                        echo "<tr><td colspan='4' class='text-center text-muted py-4'>
                                <i class='bi bi-check-circle text-success' style='font-size: 2rem;'></i><br>
                                Tất cả sản phẩm đều còn đủ hàng
                              </td></tr>";
                    }
                    ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include('../includes/footer.php'); ?>
