<?php
require_once('../includes/config.php');

if($_SERVER['REQUEST_METHOD'] == 'POST') {
    $product_id = intval($_POST['product_id']);
    $accounts = [];
    
    // Kiểm tra sản phẩm có tồn tại
    $product_check = $conn->query("SELECT name FROM products WHERE id = $product_id");
    if(!$product_check || $product_check->num_rows == 0) {
        $_SESSION['message'] = showAlert('Sản phẩm không tồn tại!', 'danger');
        header('Location: accounts.php');
        exit();
    }
    $product_name = $product_check->fetch_assoc()['name'];
    
    // Xử lý upload file
    if(isset($_FILES['accounts_file']) && $_FILES['accounts_file']['error'] == 0) {
        $file = $_FILES['accounts_file'];
        
        // Kiểm tra extension
        $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
        if($ext != 'txt') {
            $_SESSION['message'] = showAlert('Chỉ chấp nhận file .txt!', 'danger');
            header('Location: accounts.php');
            exit();
        }
        
        // Đọc file
        $content = file_get_contents($file['tmp_name']);
        $lines = explode("\n", $content);
        
        foreach($lines as $line) {
            $line = trim($line);
            if(!empty($line)) {
                $accounts[] = $line;
            }
        }
    }
    // Hoặc xử lý từ textarea
    elseif(isset($_POST['accounts_text']) && !empty($_POST['accounts_text'])) {
        $lines = explode("\n", $_POST['accounts_text']);
        
        foreach($lines as $line) {
            $line = trim($line);
            if(!empty($line)) {
                $accounts[] = $line;
            }
        }
    }
    
    // Thêm tài khoản vào database
    if(count($accounts) > 0) {
        $success_count = 0;
        $error_count = 0;
        
        foreach($accounts as $account_data) {
            $account_data = $conn->real_escape_string($account_data);
            
            // Validate format (phải có dấu |)
            if(strpos($account_data, '|') === false) {
                $error_count++;
                continue;
            }
            
            $sql = "INSERT INTO product_accounts (product_id, account_data, is_sold) 
                    VALUES ($product_id, '$account_data', 0)";
            
            if($conn->query($sql)) {
                $success_count++;
            } else {
                $error_count++;
            }
        }
        
        // Log hoạt động
        writeLog(0, 'BULK_ADD_ACCOUNTS', "Thêm hàng loạt $success_count tài khoản cho sản phẩm: $product_name");
        
        // Thông báo kết quả
        if($success_count > 0 && $error_count == 0) {
            $_SESSION['message'] = showAlert("✅ Đã thêm thành công $success_count tài khoản!", 'success');
        } elseif($success_count > 0 && $error_count > 0) {
            $_SESSION['message'] = showAlert("⚠️ Thêm thành công $success_count tài khoản, thất bại $error_count tài khoản!", 'warning');
        } else {
            $_SESSION['message'] = showAlert("❌ Không thể thêm tài khoản nào! Kiểm tra lại format.", 'danger');
        }
    } else {
        $_SESSION['message'] = showAlert('Không có tài khoản nào để thêm!', 'warning');
    }
} else {
    $_SESSION['message'] = showAlert('Yêu cầu không hợp lệ!', 'danger');
}

header('Location: accounts.php');
exit();
?>
